' Started.... 20/08/2022
' Microcontroller used:  Microchip Technology PIC12F617
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com 

'--------Program Desciption--------
  
' When the switch is closed the servo moves through 90 degrees when the switch
' opens it moves back to start. The potentiometers enable you to trim the start and
'end positions to align with the platform  max and minimum positions. 
 #CONFIG
  __CONFIG   _CP_OFF & _BOR_OFF & _MCLRE_ON & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _IOSCFS_4MHZ & _WRT_OFF
   #ENDCONFIG
   
OSCTUNE = %00000000
'
' 
                                                                                                                                   
 
    DEFINE OSC 4  'oscillator 4MHz was 8mhz
    
    Define  ADC_BITS     10    ' Set number of bits in result
	Define  ADC_CLOCK    3     ' Set clock source (3=rc)
	Define  ADC_SAMPLEUS 50    ' Set sampling time in uS                                                      
    
     
       
'------------Variables-------------
   x  var word  ' adc GP1
   y var word   '2 * adc GP1
   b var word   'ms delay between servo step
   e var word   'adc GP4 (AN3)
   f var word   ' 2 * adc GP4
  
          ' ADC reading 
'----------Initialization----------
    ANSEL = %00010010  ' GP1, GP4 analogue rest digital
   TRISIO = %10011110 ' GP1,GP2, GP3.GP4 inputs rest outputs  
   INTCON.7 = 0
   INTCON.6 = 0                
   CMCON0.7 = 0  'comparitor off
 VRCON.7 = 0' comparitor voltage reference module off 
 OPTION_REG.7 = 1 'pull ups disabled 
    ADCON0 = %10000111  ' ADC GP1
  
   
 
  
                      
    
  
  x = 0
  y = 0  'pot sets this to 1000 GP1
  b = 20
 
  e = 0
  f = 0  'pot sets this to 2000 GP4
  
'-------------Main Code------------
  PAUSE 100 ' Wait 0.1 sec 
   ADCON0 = %10000111  'ADC on to measure GP1 1000
 
  
  ADCIN 1,X 'read ADC on GP1 and store 10 bit number in X 1000us
  y = x * 2
   ADCON0 = %10001111  'ADC on to measure GP4 2000
 
  adcin 3, e  
  f = e * 3  '2000  1966 pot mid way
 
  Start:
  if GPIO.2 = 0 then goto Bottom  'switch open
  if GPIO.2 = 1 then goto TOP        'switch closed
 Bottom:
  ADCON0 = %10001111  'ADC on to measure GP4 2000  
  adcin 3, e  
  f = e * 3  '2000  1966 pot mid way
 GPIO.0 = 1  
pauseus f' set to 2000 by pot from GP4
 GPIO.0 = 0  
pause b 
if GPIO.2 = 0 then goto Bottom
if GPIO.2 = 1 then goto Top
Top:
 ADCON0 = %10000111  'ADC on to measure GP1 1000
 ADCIN 1,X 'read ADC on GP1 and store 10 bit number in X 1000us
 y = x * 2  '1062 mid point
GPIO.0 = 1
pauseus y  'set  to 1000 from GP1
GPIO.0 = 0
pause b
goto Start

